/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.util.AboutUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class Util {
    public static final Logger logger = LoggerManager.getLogger((String)"autoplot");

    private static String tagName(String svnURL, Map<String, String> abbrevs) {
        if (svnURL == null) {
            return "untagged";
        }
        String root = svnURL;
        int i = root.lastIndexOf(47);
        if (i == -1) {
            return root;
        }
        int i2 = root.lastIndexOf(47, i - 1);
        String dir = root.substring(i2 + 1, i);
        String abbrev = abbrevs.get(root = root.substring(0, i2 + 1));
        if (abbrev == null) {
            int j = abbrevs.size() + 1;
            abbrevs.put(root, "[" + j + "]");
            abbrev = abbrevs.get(root);
        }
        return abbrev + " " + dir;
    }

    private static String popDollarValue(String propval) {
        int i = propval.indexOf(36);
        if (i == -1) {
            return "";
        }
        int i2 = propval.indexOf(36, (i = propval.indexOf(58, i + 1)) + 1);
        if (i2 == -1) {
            return "";
        }
        return propval.substring(i + 1, i2).trim();
    }

    private static String svnTag(String urlprop, String revprop, String jarName) {
        if (urlprop == null || revprop == null) {
            return null;
        }
        String suffix = "src/META-INF/build.txt";
        urlprop = Util.popDollarValue(urlprop);
        revprop = Util.popDollarValue(revprop);
        if (urlprop.length() == 0 || revprop.length() == 0) {
            return null;
        }
        if (urlprop.endsWith(suffix)) {
            urlprop = urlprop.substring(0, urlprop.length() - suffix.length());
        }
        if (urlprop.endsWith(jarName = jarName + "/")) {
            urlprop = urlprop.substring(0, urlprop.length() - jarName.length());
        }
        return urlprop + "@" + revprop;
    }

    public static String getBuildTime() {
        String buildTime = "????";
        URL buildURL = AboutUtil.class.getResource("/buildTime.txt");
        if (buildURL != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(buildURL.openStream()));){
                buildTime = reader.readLine();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return buildTime;
    }

    public static List<String> getBuildInfos() throws IOException {
        Enumeration<URL> urls = Util.class.getClassLoader().getResources("META-INF/build.txt");
        ArrayList<String> result = new ArrayList<String>();
        String buildTime = Util.getBuildTime();
        result.add("build time: " + buildTime);
        LinkedHashMap<String, String> abbrevs = new LinkedHashMap<String, String>();
        while (urls.hasMoreElements()) {
            String jarname;
            String name;
            URL url = urls.nextElement();
            String jar = url.toString();
            int i = jar.indexOf(".jar");
            int i0 = jar.lastIndexOf(47, i - 1);
            if (i != -1) {
                name = jar.substring(i0 + 1, i + 4);
                jarname = name.substring(0, name.length() - 4);
            } else {
                jarname = name = jar.substring(6);
            }
            Properties props = new Properties();
            props.load(url.openStream());
            String svnTag = Util.svnTag(props.getProperty("build.svnurl"), props.getProperty("build.svnrevision"), jarname);
            String tagName = Util.tagName(svnTag, abbrevs);
            result.add(name + ": " + tagName + " (" + props.getProperty("build.timestamp") + " " + props.getProperty("build.user.name") + ")");
        }
        for (Map.Entry val : abbrevs.entrySet()) {
            result.add("" + (String)val.getValue() + " " + (String)val.getKey());
        }
        return result;
    }

    public static boolean deleteFileTree(File root) throws IllegalArgumentException {
        if (!root.exists()) {
            return true;
        }
        if (!root.canRead()) {
            throw new IllegalArgumentException("cannot read root: " + root);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root should be directory: " + root);
        }
        File[] children = root.listFiles();
        if (children == null) {
            return true;
        }
        boolean success = true;
        for (File children1 : children) {
            if (children1.isDirectory()) {
                success = success && Util.deleteFileTree(children1);
                continue;
            }
            boolean bl = success = success && (!children1.exists() || children1.delete());
            if (success) continue;
            throw new IllegalArgumentException("unable to delete file " + children1);
        }
        boolean bl = success = success && (!root.exists() || root.delete());
        if (!success) {
            throw new IllegalArgumentException("unable to delete folder " + root);
        }
        return success;
    }

    public static boolean copyFile(File srcf, File dstf) throws IOException {
        WritableByteChannel dest = Channels.newChannel(new FileOutputStream(dstf));
        ReadableByteChannel src = Channels.newChannel(new FileInputStream(srcf));
        DataSourceUtil.transfer((ReadableByteChannel)src, (WritableByteChannel)dest);
        return true;
    }

    public static boolean copyFileTree(File root, File dst) {
        return Util.copyFileTree(root, dst, 0, (ProgressMonitor)new NullProgressMonitor());
    }

    public static boolean copyFileTree(File root, File dst, ProgressMonitor mon) {
        return Util.copyFileTree(root, dst, 0, mon);
    }

    public static boolean copyFileTree(File root, File dst, int depth, ProgressMonitor mon) {
        try {
            String roots = root.getCanonicalPath() + "/";
            String dsts = dst.getCanonicalPath() + "/";
            if (dsts.startsWith(roots)) {
                throw new IllegalArgumentException("can't move files into child of original");
            }
            if (roots.startsWith(dsts)) {
                throw new IllegalArgumentException("can't move files to parent of original");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (!root.exists()) {
            return false;
        }
        if (!root.canRead()) {
            throw new IllegalArgumentException("cannot read root: " + root);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root should be directory: " + root);
        }
        File[] children = root.listFiles();
        boolean success = true;
        if (!dst.exists() && !dst.mkdirs()) {
            throw new IllegalArgumentException("unable to make directory " + dst);
        }
        if (mon != null) {
            mon.setTaskSize((long)(children.length * 10));
        }
        int i = 0;
        for (File child : children) {
            if (mon != null) {
                mon.setTaskProgress((long)i);
                if (mon.isCancelled()) {
                    return false;
                }
            }
            if (child.isDirectory()) {
                if (depth < 3 && mon != null) {
                    success = success && Util.copyFileTree(child, new File(dst, child.getName()), depth + 1, mon.getSubtaskMonitor(i * 10, (i + 1) * 10, child.getName()));
                } else {
                    boolean bl = success = success && Util.copyFileTree(child, new File(dst, child.getName()), depth + 1, null);
                }
                if (!success) {
                    Util.copyFileTree(child, new File(dst, child.getName()));
                    throw new IllegalArgumentException("unable to move file " + child);
                }
            } else {
                try {
                    boolean bl = success = success && Util.copyFile(child, new File(dst, child.getName()));
                    if (!success) {
                        throw new IllegalArgumentException("unable to move file " + child);
                    }
                }
                catch (IOException ex) {
                    IllegalArgumentException ex2 = new IllegalArgumentException("unable to move file " + child, ex);
                    throw ex2;
                }
            }
            ++i;
        }
        return success;
    }

    public static boolean pruneFileTree(File root, List<String> problems) {
        if (!root.exists()) {
            return false;
        }
        if (!root.canRead()) {
            throw new IllegalArgumentException("cannot read root: " + root);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root should be directory: " + root);
        }
        File[] children = root.listFiles();
        if (children == null) {
            return false;
        }
        boolean success = true;
        for (File children1 : children) {
            if (!children1.isDirectory()) continue;
            success = success && Util.pruneFileTree(children1, problems);
        }
        if (children.length == 0) {
            if (!root.delete()) {
                problems.add("unable to delete " + root);
                return false;
            }
            return true;
        }
        return true;
    }

    public static String strjoin(Collection<String> c, String delim) {
        StringBuilder result = new StringBuilder();
        for (String s : c) {
            if (result.length() > 0) {
                result.append(delim);
            }
            result.append(s);
        }
        return result.toString();
    }

    public static void addFonts() {
        String[] ss;
        Class<Util> c = Util.class;
        for (String s : ss = new String[]{"/resources/Roboto-Regular.ttf", "/resources/ArchitectsDaughter.ttf", "/resources/xkcd-script.ttf", "/resources/scheme_bk.otf"}) {
            try (InputStream in = c.getResourceAsStream(s);){
                if (in == null) continue;
                Font font = Font.createFont(0, in);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                ge.registerFont(font);
            }
            catch (FontFormatException | IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }
}

